// Programm 3-11c: BSP_ROOT/meinewebapp/WEB-INF/classes/jdbcbasis/InsertUndDelete.java
import java.sql.*;
public class InsertUndDelete {
  public static void main(String[] args) throws Exception {
    if (args.length < 3) System.exit(0);
    String modus = args[0];
    Class.forName("oracle.jdbc.driver.OracleDriver");
    Connection c = DriverManager.getConnection(
                   "jdbc:oracle:thin:@p30:1521:jdbcbuch", "system", "manager");
    Statement s = c.createStatement();
    s.execute("CREATE OR REPLACE " + 
          "FUNCTION dHire (v IN STRING, n IN STRING) " +
          "RETURN INTEGER IS temp INTEGER; BEGIN " +
          "SELECT Max(dcode) INTO temp FROM Dozenten; " +
          "INSERT INTO Dozenten (dcode, vorname, nachname) " +
          "VALUES (temp + 1, v, n); RETURN temp + 1; END;");
    s.execute("CREATE OR REPLACE " + 
          "PROCEDURE dFire (dc IN INTEGER, v IN STRING, " +
          "n IN STRING) IS BEGIN DELETE FROM Dozenten WHERE dcode=dc " +
          "AND rtrim(vorname) LIKE v AND rtrim(nachname) LIKE n; END;");
    CallableStatement cs;
    if (modus.toUpperCase().startsWith("H")) {
      cs = c.prepareCall("{? = call dHire(?,?)}");
      cs.registerOutParameter(1, Types.INTEGER);
      cs.setString(2, args[1]); cs.setString(3, args[2]);
      cs.execute();
      System.out.println("Code= " + cs.getInt(1));
    }
    if (modus.toUpperCase().startsWith("F")) {
      cs = c.prepareCall("{call dFire(?,?,?)}");
      cs.setString(2, args[1]);
      cs.setString(3, args[2]);
      if (args.length > 3) {
        cs.setInt(1, Integer.parseInt(args[3]));
        cs.execute();
      }
      else 
        System.out.print("nicht ");
      System.out.println("gelscht!");
    }
  }
}