// Programm 4-2a: BSP_ROOT/meinewebapp/WEB-INF/classes/jdbccs/MysqlDirektServer.java
import java.io.*;
import java.net.*;
import java.sql.*;
public class MysqlDirektServer {
  final static int port = 6787;
  ServerSocket servsock;
  Connection c; Statement s;
  int zhler;
  public MysqlDirektServer() {
    try {
      registerDatabase();
      servsock = new ServerSocket(port);
      System.out.println("\nMiddleware Server auf Port " + port + " ...\n");
    }
    catch (Exception ex) {ex.printStackTrace();}
    while(true) {                         // Serverschleife
      StringBuffer  buf = new StringBuffer();
      String addr = "";
      try  {
        Socket lauschen = servsock.accept();
        byte[] ad = (lauschen.getInetAddress()).getAddress();
        for (int i = 0; i < 4; i++) addr += (ad[i]&0xff) + ".";
        InputStream in = lauschen.getInputStream();
        PrintWriter out = new PrintWriter(lauschen.getOutputStream());
        zhler++;
        for (int ch; (ch = in.read()) > 0;)
          buf.append((char) ch);
        out.print(queryDatabase(buf.toString()));
        out.close();
      }
      catch (Exception ex) {ex.printStackTrace();}
      System.out.println(zhler + ": " + addr + " " + buf.toString());
    }
  }
  private void registerDatabase() throws Exception {
    Class.forName("org.gjt.mm.mysql.Driver"); 
    c = DriverManager.getConnection("jdbc:mysql://host:3306/Kurse", "root", "");
    s = c.createStatement();
  }
  private String queryDatabase(String sql) {
    StringBuffer buf = new StringBuffer();
    try {
      if (s.execute(sql)) {
        ResultSet rs = s.getResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        while(rs.next()) {
           for (int i  = 1, max = rsmd.getColumnCount(); i <= max; i++)
            buf.append(rs.getString(i) + (i == max ? "\n" : ", "));
        }
      }
      else
        buf.append(String.valueOf(s.getUpdateCount()) + " Zeile(n)");
    }
    catch (Exception ex) {
      buf.append("SQL-Fehler!\n" + ex.getMessage());
    }
    finally {
      return buf.toString();
    }
  }
  public static void main(String[] args) {  
    new SqlDirektServer();                  // Server starten
  }
}