// Programm 4-1a: BSP_ROOT/meinewebapp/WEB-INF/classes/jdbccs/SqlDirektClient.java
import java.awt.*;             // GUI Fenster etc.
import java.awt.event.*;       // GUI Events
import java.io.*;              // fr Streams von/zum Server
import java.net.*;             // Internet
public class SqlDirektClient extends Frame implements ActionListener {
  // Internet-Adresse und -Port des Servers
  static final String server = "localhost"; 
  static final int port = 6789;
  // GUI-Komponenten
  Button ausfhren = new Button("Ausfhren!");
  TextArea ein = new TextArea("SELECT", 5, 60);
  TextArea aus = new TextArea();
  public SqlDirektClient() {
    super("SQLDirekt per Middleware");    // Fensterbezeichnung
    Panel eingabe = new Panel(new BorderLayout());
    Panel knopf = new Panel(new FlowLayout(FlowLayout.LEFT));
    knopf.add(ausfhren);
    eingabe.add(knopf, "North");
    eingabe.add(ein, "Center");
    add(eingabe, "North");
    add(aus, "Center");
    aus.setEditable(false);             // fr Eingaben sperren
    ausfhren.addActionListener(this);  // Eventlistener reg.
    setSize(500, 400);                  // Fenstergre
    setVisible(true);                   // Fenster anzeigen
  }
  public void actionPerformed(ActionEvent e) {
    String sql = ein.getText();
    try {
      String resultat = sendeSql(sql);
      aus.setText(resultat);
   }
    catch (Exception ex) { aus.setText("SQL: " + "\nFehler:\n" + ex.getMessage()); }
  }
  private String sendeSql(String text) throws Exception {
    Socket socket = new Socket(server, port);
    PrintWriter out = new PrintWriter(socket.getOutputStream());
    out.print(text + "\0"); out.flush();
    InputStream in  = socket.getInputStream();
    StringBuffer buf = new StringBuffer();
    for (int ch; (ch = in.read()) > -1;) 
      buf.append((char) ch);
    socket.close();
    return buf.toString();
  }
  public static void main(String[] args) {  // Programmstart
    new SqlDirektClient();                  // Client-Start
  }
}