 // Programm 4-3b: BSP_ROOT/meinewebapp/WEB-INF/classes/jdbccs/SqlDirektHttpServer.java
import java.io.*;
import java.net.*;
import java.sql.*;

public class SqlDirektHttpServer {
  final static int LF = 10, port = 6785;
  ServerSocket servsock;
  Connection c; Statement s;
  int zhler;
  public SqlDirektHttpServer() {
    try {
      registerDatabase();
      servsock = new ServerSocket(port);
      System.out.println("\nMiddleware Server auf Port " + port + " ...\n");
    }
    catch (Exception ex) {ex.printStackTrace();}
    while(true) {                           // Serverschleife
      StringBuffer  buf = new StringBuffer();
      String addr = "";
      try  {
        Socket lauschen = servsock.accept();
        byte[] ad = (lauschen.getInetAddress()).getAddress();
        for (int i = 0; i < 4; i++)
          addr += (ad[i]&0xff) + ".";
        InputStream in = lauschen.getInputStream();
        PrintWriter out = new PrintWriter(lauschen.getOutputStream());
        zhler++; 
        boolean skip = true;
        for (int ch; (ch = in.read()) != LF;) {
          if (skip) { if (ch == '=') skip = false; }
          else if (ch == '+') buf.append(' '); 
          else if (ch == '/') break; 
          else if (ch == '%') {
            StringBuffer temp = new StringBuffer();
            temp.append((char) in.read());
            temp.append((char) in.read());
            buf.append((char) Integer.parseInt(temp.toString(), 16));
          }
          else buf.append((char) ch);
        }
        out.print("HTTP/1.0 200 OK\nContent-type: text/html\n\n");
        out.print(queryDatabase(buf.toString()));
        out.close();
      }
      catch (Exception ex) {ex.printStackTrace();}
      System.out.println(zhler + ": " + addr + " " + buf.toString());
    }
  }
  private void registerDatabase() throws Exception {
    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver"); 
    c = DriverManager.getConnection("jdbc:odbc:Kurse");
    s = c.createStatement();
  }
  private String queryDatabase(String sql) {
    StringBuffer buf = new StringBuffer("<PRE>\n");
    try {
      boolean resultset = s.execute(sql);
      if (resultset) {
        ResultSet rs = s.getResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
         while(rs.next()) {
          for (int i  = 1, max = rsmd.getColumnCount(); i <= max; i++)
            buf.append(rs.getString(i) + (i == max ? "\n" : ", "));
        }
      }
      else
        buf.append(String.valueOf(s.getUpdateCount()) + " Zeile(n)");
    }
    catch (Exception ex) {
      buf = new StringBuffer("SQL-Fehler!\n" + ex.getMessage());
    }
    finally { return buf.toString(); }
  }
  public static void main(String[] args) {
    new SqlDirektHttpServer();         // Server starten
  }
}