// Programm 5-21: BUCH_ROOT/meinewebapp/WEB-INF/classes/meineapps/SqlDirekt.java 
package meineapps;
import javax.servlet.*; import javax.servlet.http.*;
import java.io.*;
import java.sql.*;       // JDBC
public class SqlDirekt extends HttpServlet {
  static final String DBS = "Spielzeugauktion";
  static final String driver  = "org.gjt.mm.mysql.Driver";
  static final String jdbcurl = "jdbc:mysql://localhost:3306/" + DBS + 
                                                             "?user=root&passwd=";
  static final String SQL = "SELECT * FROM spielzeug";
  static final String EXEC = "Ausf&uuml;hren und anzeigen";
  Connection c;
  public void init() {
    try {
      Class.forName(driver);
      c = DriverManager.getConnection(jdbcurl);
    }
    catch(Exception e) {;}
  }

  public void doGet(HttpServletRequest rq, HttpServletResponse rs)
	                             throws ServletException, IOException {
    rs.setContentType("text/html");
    PrintWriter out = rs.getWriter();
    String sql = rq.getParameter("sql"); sql = sql != null ? sql : SQL;
    out.print(
      "<TITLE>SQL direkt: Servlet, JDBC und MySQL</TITLE>" +
      "<H2>SqlDirekt mit Servlet, JDBC und MySQL</H2>" +
      "<FORM><INPUT Type=text readonly Value=" + DBS + "><BR>" +
      "<TEXTAREA Name=sql Rows=4 Cols=60>" + sql + "</TEXTAREA><BR>" +
      "<INPUT Type=submit Value='" + EXEC + "'></FORM>");
    try {
      Statement s = c.createStatement();     // SQL-Anweisung
      if (s.execute(sql)) {                  // ..ausfhren!
        ResultSet r = s.getResultSet();
        ResultSetMetaData rm = r.getMetaData();
        int count = rm.getColumnCount();
        for (int i = 1; i <= count; i++) {   // Spaltennamen
          out.print(rm.getColumnName(i));
          if (i != count) out.print(", "); else out.println("<BR>");
        }
        while(r.next())
          for (int i = 1; i <= count; i++) { // Spaltenwerte
            out.print(r.getString(i));
            if (i != count) out.print(", "); else out.println("<BR>");
          }
      }
    }
    catch(Exception ex) {
      out.println("Fehler: " + ex.getMessage() + "<BR>" + sql);
    }
  }
}