// Programm 5-18a: BSP_ROOT/meinewebapp/WEB-INF/classes/meinefilter/LoggingFilter.java
package meinefilter;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

public class LoggingFilter implements Filter {
  private FilterConfig fc = null;
  String datei;
  public void init(FilterConfig fc) {
    this.fc = fc;
    datei = fc.getServletContext().getRealPath("/") + 
                                         fc.getInitParameter("logdatei");
  }
  public void destroy() {
    this.fc = null;
  }
  public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain)
                                           throws ServletException, IOException {
    if (fc == null) return;
    try {
      FileWriter f = new FileWriter(datei, true);
      f.write(new Date() + ";");
      f.write(((HttpServletRequest) rq).getRequestedSessionId() + ";");
      f.write(((HttpServletRequest) rq).getRemoteHost() + ";");
      f.write(((HttpServletRequest) rq).getRequestURL() + "\n");
      f.close();
    } catch (Exception e) {}
    chain.doFilter(rq, rs);
  }
}