// Programm 6-2:  ./OracleUndSwing/DemoTabelle.java
import java.awt.*;       import javax.swing.*;
import java.awt.event.*; import javax.swing.table.*;

// UI Delegate (View und Controller)  
class DemoTabelle extends JFrame {
  DemoTabelleModel m = new DemoTabelleModel();
  JTable table = new JTable(m);

  public DemoTabelle() {
    super("MVC Tabelle (Demo)");
    Panel oben = new Panel(new GridLayout(0, 2));
    Button neuZeile = new Button("neue Zeile");
    Button delZeile = new Button("markierte Zeile lschen");
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add("North", oben);
    oben.add(neuZeile);
    oben.add(delZeile);
    getContentPane().add("Center", new JScrollPane(table));
    table.setColumnSelectionAllowed(false);
    table.setSelectionMode(
                          ListSelectionModel.SINGLE_SELECTION);
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    neuZeile.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        m.neueZeile();
        table.setRowSelectionInterval(m.getRowCount()-1,
                                      m.getRowCount()-1); }});
    delZeile.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        m.lscheZeile(table.getSelectedRow());
        table.setRowSelectionInterval(m.getRowCount()-1,
                                      m.getRowCount()-1); }});
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0); } });
    setSize(500, 400);
    setVisible(true);
  }

  public static void main(String[] p) {
    new DemoTabelle();
  }
}                                    // Ende class DemoTabelle

// Model
class DemoTabelleModel extends DefaultTableModel {
  int zhler;
  static final int cols = 16, rows = 10;
  
  public DemoTabelleModel() {
    super(0, cols);
    for (int i = 0; i < rows; i++) 
      neueZeile();
    Object[] namen = new Object[cols];
    for (int i = 0; i < cols; i++)
      namen[i] = "Spalte " + i;
    setColumnIdentifiers(namen);
  }
  public boolean isCellEditable(int row, int col) {
    if (col == 0) return false;
    else return super.isCellEditable(row, col);
  }
  public void setValueAt(Object o, int row, int col) {
    try {
      Integer.parseInt((String) o);
      super.setValueAt(o, row, col);
    }
    catch(NumberFormatException e) {}
  }

  void neueZeile() {
    Object[] temp = new Object[cols];
    for (int i = 0; i < cols; i++)
      temp[i] = String.valueOf((zhler + 1) * (i + 1) - 1 );
    addRow(temp);
    zhler++;
  }
  void lscheZeile(int row) {
    if (row < 0 || row >= getRowCount()) return;
    removeRow(row);
  }
}                               // Ende class DemoTabelleModel
