// Programm 6-1:  ./OracleUndSwing/MVCScrollbar.java
import java.awt.*;         import javax.swing.*;
import java.awt.event.*;

// UI Delegate (View und Controller)
class MVCScrollbar extends JFrame {
  MVCScrollbarModel model = new MVCScrollbarModel();
  JScrollBar jbar;
  Label anzeige = new Label("", Label.CENTER);
  
  public MVCScrollbar() {
    super("MVC Scroll Bar");
    jbar = new JScrollBar(JScrollBar.HORIZONTAL);
    jbar.setModel(model);
    jbar.addAdjustmentListener(new AdjustmentListener() {
      public void adjustmentValueChanged(AdjustmentEvent e) {
        anzeige.setText("" + model.getDouble()); } });
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add("Center", anzeige);
    anzeige.setText("" + model.getDouble()); 
    getContentPane().add("South", jbar);
    setSize(300, 100);
    setVisible(true);
  }
  public static void main(String[] args) {
    new MVCScrollbar();
  }
}                                   // Ende class MVCScrollbar

// Model
class MVCScrollbarModel extends DefaultBoundedRangeModel {
  double getDouble() {
    return ((double) getValue())/(getMaximum() - getMinimum());
  }
}                              // Ende class MVCScrollbarModel
