// Programm 2-1: BSP_ROOT/meinewebapp/WEB-INF/classes/relsql/SqlDirektSelect.java
import java.sql.*; 
import java.awt.*; 
import java.awt.event.*;
public class SqlDirektSelect extends Frame implements ActionListener {
  // GUI-Komponenten definieren
  Button ausfhren = new Button("Ausfhren!");
  TextArea ein = new TextArea("SELECT", 3, 80);
  TextArea ausgabe = new TextArea();
  // DBMS-Variable
  Connection c;
  Statement s;
  public SqlDirektSelect() {
    super("SQL Direkt");                // Fensterbezeichnung
    Panel eingabe = new Panel(new BorderLayout());
    Panel knopf = new Panel(new FlowLayout(FlowLayout.LEFT));
    knopf.add(ausfhren);
    eingabe.add(knopf, "North");
    eingabe.add(ein, "Center");
    add(eingabe, "North");
    add(ausgabe, "Center");
    addWindowListener(new WindowAdapter() {     // Window Exit
      public void windowClosing(WindowEvent e) {
        System.exit(0); } });
    ausgabe.setEditable(false);         // Ausgabefenster fr Eingaben sperren
    ausfhren.addActionListener(this);  // Eventlistener registrieren
    setSize(500, 400);                  // Fenstergre
    setVisible(true);                   // Fenster anzeigen
    // DBMS-Treiber registrieren, Verbindung mit Datenbank herstellen
    try {
      Class.forName("sun.jdbc.odbc.JdbcOdbcDriver"); 
      c = DriverManager.getConnection("jdbc:odbc:Kurse");
      s = c.createStatement();
    }
    catch (Exception ex) {
      ausgabe.setText("Fehler:\n" + ex.getMessage());
    }
  }
  public void actionPerformed(ActionEvent e) {
    String sql = ein.getText();
    ResultSet r;
    try {
      r = s.executeQuery(sql);         // SQL SELECT ausfhren
      ResultSetMetaData rm = r.getMetaData();
      int x = rm.getColumnCount();
      ausgabe.setText("");
      for (int i = 1; i <= x; i++) {
        ausgabe.append(rm.getColumnName(i));
        if (i != x) ausgabe.append(", ");
        else ausgabe.append("\n");
      }
      while(r.next()) {
        for (int i = 1; i <= x; i++) {
          ausgabe.append(r.getString(i));
          if (i != x) ausgabe.append(", ");
          else ausgabe.append("\n");
        }
      }
    }
    catch (Exception ex) {
      ausgabe.setText("SQL: " + sql + "\nFehler:\n" + ex.getMessage());
    }
  }
  public static void main(String[] args) {
    new SqlDirektSelect();                   // GUI-Start
  }
}